<?php
/* --------------------------------------------------------------
 ModulesFinder.php 2020-03-13
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Menu\EventListeners\GxModules;

use DirectoryIterator;
use Gambio\Core\Application\ValueObjects\Path;
use IteratorIterator;

/**
 * Class ModulesFinder
 * @package Gambio\Admin\Layout\Menu\EventListeners\GxModules
 * @codeCoverageIgnore
 */
class ModulesFinder
{
    /**
     * @var Path
     */
    private $path;
    
    
    /**
     * MenuFilesFinder constructor.
     *
     * @param Path $path
     */
    public function __construct(Path $path)
    {
        $this->path = $path;
    }
    
    
    /**
     * Returns a list of all gx modules.
     *
     * @return array
     */
    public function findModules(): array
    {
        $gxModulesDir = "{$this->path->base()}/GXModules";
        
        $modules  = [];
        $iterator = new IteratorIterator(new DirectoryIterator($gxModulesDir));
        
        foreach ($iterator as $dir) {
            /** @var DirectoryIterator $dir */
            if ($dir->isDir() && !$dir->isDot()) {
                $vendor    = realpath($dir->getPathname());
                $modules[] = $this->vendorsModules($vendor);
            }
        }
        $modules = array_merge(...$modules);
        
        return $modules;
    }
    
    
    /**
     * Returns a list of modules for the given vendor dir.
     *
     * @param string $vendorDir
     *
     * @return array
     */
    private function vendorsModules(string $vendorDir): array
    {
        $modules  = [];
        $iterator = new IteratorIterator(new DirectoryIterator($vendorDir));
        
        foreach ($iterator as $dir) {
            /** @var DirectoryIterator $dir */
            if ($dir->isDir() && !$dir->isDot()) {
                $modules[] = realpath($dir->getPathname());
            }
        }
        
        return $modules;
    }
}